Rem CropMarks.vbs
Rem An InDesign VBScript
Rem
Rem Draws crop marks and/or registration marks around the selected object or objects.
Rem
Rem For more on InDesign/InCopy scripting see the documentation included in the Scripting SDK 
Rem available at http://www.adobe.com/devnet/indesign/sdk.html
Rem or drop by the InDesign scripting user to user forum at http://www.adobeforums.com.
Rem
main
Function main()
	ReDim myObjectList(0)
	Set myInDesign = CreateObject("InDesign.Application.2022")
	Rem Set the user interaction level to allow the display of dialog boxes and alerts.
	myInDesign.ScriptPreferences.UserInteractionLevel = idUserInteractionLevels.idInteractWithAll
	If myInDesign.Documents.Count <> 0 Then
	    If myInDesign.Selection.Count <> 0 Then
	        For myCounter = 1 To myInDesign.Selection.Count
	            Select Case TypeName(myInDesign.Selection.Item(myCounter))
	                Case "Rectangle", "Oval", "Polygon", "GraphicLine", "Button", "Group", "TextFrame"
	                    If Not (IsEmpty(myObjectList(0))) Then
	                        ReDim Preserve myObjectList(UBound(myObjectList) + 1)
	                    End If
	                    Set myObjectList(UBound(myObjectList)) = myInDesign.Selection.Item(myCounter)
	            End Select
	        Next
	        If Not (IsEmpty(myObjectList(0))) Then
	            myDisplayDialog myInDesign, myObjectList
	        End If
	    Else
	        MsgBox ("Nothing is selected. Please select an object and try again.")
	    End If
	Else
	    MsgBox ("Please open a document, select an object, and try again.")
	End If
End function
Function myDisplayDialog(myInDesign, myObjectList)
Set myDialog = myInDesign.Dialogs.Add
myDialog.Name = "CropMarks"
With myDialog.DialogColumns.Add
    Set myCropMarksGroup = .EnablingGroups.Add
    myCropMarksGroup.StaticLabel = "Crop Marks"
    myCropMarksGroup.CheckedState = True
    With myCropMarksGroup.DialogColumns.Add
        With .StaticTexts.Add
            .StaticLabel = "Options:"
        End With
    End With
    With myCropMarksGroup.DialogColumns.Add
        With .StaticTexts.Add
            .StaticLabel = "Length:"
        End With
        With .StaticTexts.Add
            .StaticLabel = "Offset:"
        End With
        With .StaticTexts.Add
            .StaticLabel = "Stroke Weight:"
        End With
    End With
    With myCropMarksGroup.DialogColumns.Add
        Set myCropMarkLengthField = .MeasurementEditboxes.Add
        myCropMarkLengthField.EditUnits = idMeasurementUnits.idPoints
        myCropMarkLengthField.EditValue = 6
        Set myCropMarkOffsetField = .MeasurementEditboxes.Add
        myCropMarkOffsetField.EditUnits = idMeasurementUnits.idPoints
        myCropMarkOffsetField.EditValue = 3
        Set myCropMarkStrokeWeightField = .MeasurementEditboxes.Add
        myCropMarkStrokeWeightField.EditUnits = idMeasurementUnits.idPoints
        myCropMarkStrokeWeightField.EditValue = 0.25
    End With
    Set myRegMarksGroup = .EnablingGroups.Add
    myRegMarksGroup.StaticLabel = "Registration Marks"
    myRegMarksGroup.CheckedState = True
    With myRegMarksGroup.DialogColumns.Add
        With .StaticTexts.Add
            .StaticLabel = "Options:"
        End With
    End With
    With myRegMarksGroup.DialogColumns.Add
        With .StaticTexts.Add
            .StaticLabel = "Inside Target Radius:"
        End With
        With .StaticTexts.Add
            .StaticLabel = "Outside Target Radius:"
        End With
        With .StaticTexts.Add
            .StaticLabel = "Outside Radius:"
        End With
        With .StaticTexts.Add
            .StaticLabel = "Offset:"
        End With
        With .StaticTexts.Add
            .StaticLabel = "Stroke Weight:"
        End With
    End With
    With myRegMarksGroup.DialogColumns.Add
        Set myRegMarkInnerRadiusField = .MeasurementEditboxes.Add
        myRegMarkInnerRadiusField.EditUnits = idMeasurementUnits.idPoints
        myRegMarkInnerRadiusField.EditValue = 2
        Set myRegMarkOuterRadiusField = .MeasurementEditboxes.Add
        myRegMarkOuterRadiusField.EditUnits = idMeasurementUnits.idPoints
        myRegMarkOuterRadiusField.EditValue = 4
        Set myRegMarkRadiusField = .MeasurementEditboxes.Add
        myRegMarkRadiusField.EditUnits = idMeasurementUnits.idPoints
        myRegMarkRadiusField.EditValue = 6
        Set myRegMarkOffsetField = .MeasurementEditboxes.Add
        myRegMarkOffsetField.EditUnits = idMeasurementUnits.idPoints
        myRegMarkOffsetField.EditValue = 3
        Set myRegMarkStrokeWeightField = .MeasurementEditboxes.Add
        myRegMarkStrokeWeightField.EditUnits = idMeasurementUnits.idPoints
        myRegMarkStrokeWeightField.EditValue = 0.25
    End With
    With .BorderPanels.Add
        With .StaticTexts.Add
            .StaticLabel = "Draw Marks Around:"
        End With
        Set myRangeButtons = .RadiobuttonGroups.Add
        With myRangeButtons.RadiobuttonControls.Add
            .StaticLabel = "Each Object"
            .CheckedState = True
        End With
        With myRangeButtons.RadiobuttonControls.Add
            .StaticLabel = "Entire Selection"
        End With
    End With
End With
myReturn = myDialog.Show
If myReturn = True Then
    Rem Get the values from the dialog box.
    myDoCropMarks = myCropMarksGroup.CheckedState
    myDoRegMarks = myRegMarksGroup.CheckedState
    myCropMarkLength = myCropMarkLengthField.EditValue
    myCropMarkOffset = myCropMarkOffsetField.EditValue
    myCropMarkStrokeWeight = myCropMarkStrokeWeightField.EditValue
    myRegMarkInnerRadius = myRegMarkInnerRadiusField.EditValue
    myRegMarkOuterRadius = myRegMarkOuterRadiusField.EditValue
    myRegMarkRadius = myRegMarkRadiusField.EditValue
    myRegMarkOffset = myRegMarkOffsetField.EditValue
    myRegMarkStrokeWeight = myRegMarkStrokeWeightField.EditValue
    myRange = myRangeButtons.SelectedButton
    myDialog.Destroy
    If ((myDoCropMarks <> False) Or (myDoRegMarks <> False)) Then
    Rem Store the current measurement units.
    myOldXUnits = myInDesign.ActiveDocument.ViewPreferences.HorizontalMeasurementUnits
    myOldYUnits = myInDesign.ActiveDocument.ViewPreferences.VerticalMeasurementUnits
    Rem Set the measurement units to points.
    myInDesign.ActiveDocument.ViewPreferences.HorizontalMeasurementUnits = idMeasurementUnits.idPoints
    myInDesign.ActiveDocument.ViewPreferences.VerticalMeasurementUnits = idMeasurementUnits.idPoints
    Rem Draw the printers marks.
        myDrawPrintersMarks myInDesign, myRange, myDoCropMarks, myDoRegMarks, myCropMarkLength, myCropMarkOffset, myCropMarkStrokeWeight, myRegMarkInnerRadius, myRegMarkOuterRadius, myRegMarkRadius, myRegMarkOffset, myRegMarkStrokeWeight, myObjectList
    Rem Reset the measurement units.
    myInDesign.ActiveDocument.ViewPreferences.HorizontalMeasurementUnits = myOldXUnits
    myInDesign.ActiveDocument.ViewPreferences.VerticalMeasurementUnits = myOldYUnits
    Else
        myDialog.Destroy
    End If
End If
End Function

Function myDrawPrintersMarks(myInDesign, myRange, myDoCropMarks, myDoRegMarks, myCropMarkLength, myCropMarkOffset, myCropMarkStrokeWeight, myRegMarkInnerRadius, myRegMarkOuterRadius, myRegMarkRadius, myRegMarkOffset, myRegMarkStrokeWeight, myObjectList)
    Set myDocument = myInDesign.ActiveDocument
    myOldRulerOrigin = myDocument.ViewPreferences.RulerOrigin
    myDocument.ViewPreferences.RulerOrigin = idRulerOrigin.idSpreadOrigin
    Rem Create a layer to hold the printers marks (if it does not already exist).
    Err.Clear
    On Error Resume Next
    Set myLayer = myDocument.Layers.Item("CropMarks")
    If Err.Number <> 0 Then
        Set myLayer = myDocument.Layers.Add
        myLayer.Name = "CropMarks"
        Err.Clear
    End If
    On Error GoTo 0
    Rem Get references to the Registration color, Paper color, and the None swatch.
    Set myRegistrationSwatch = myDocument.Swatches.Item("Registration")
    Set myPaperSwatch = myDocument.Swatches.Item("Paper")
    Set myNoneSwatch = myDocument.Swatches.Item("None")
    Rem Process the objects in the selection.
    For myCounter = 0 To UBound(myObjectList)
        Set myObject = myObjectList(myCounter)
	myBounds = myObject.VisibleBounds
        Rem Set up some initial bounding box values.
        If myCounter = 0 Then
            myX1 = myBounds(1)
            myY1 = myBounds(0)
            myX2 = myBounds(3)
            myY2 = myBounds(2)
        End If
        If myRange = 0 Then
            If myDoCropMarks = True Then
                myDrawCropMarks myInDesign, myBounds(1), myBounds(0), myBounds(3), myBounds(2), myCropMarkLength, myCropMarkOffset, myCropMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
            End If
            If myDoRegMarks = True Then
                myDrawRegMarks myInDesign, myBounds(1), myBounds(0), myBounds(3), myBounds(2), myRegMarkOffset, myRegMarkInnerRadius, myRegMarkOuterRadius, myRegMarkRadius, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myPaperSwatch, myLayer
            End If
        Else
            Rem Compare the bounds values to the stored bounds.
            Rem If a given bounds value is less than (for x1 and y1) or
            Rem greater than (for x2 and y2) the stored value,
            Rem then replace the stored value with the bounds value.
            If myBounds(0) < myY1 Then
                myY1 = myBounds(0)
            End If
            If myBounds(1) < myX1 Then
                myX1 = myBounds(1)
            End If
            If myBounds(2) > myY2 Then
                myY2 = myBounds(2)
            End If
            If myBounds(3) > myX2 Then
                myX2 = myBounds(3)
            End If
        End If
    Next
    If myRange <> 0 Then
            If myDoCropMarks = True Then
                myDrawCropMarks myInDesign, myX1, myY1, myX2, myY2, myCropMarkLength, myCropMarkOffset, myCropMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
            End If
            If myDoRegMarks = True Then
                myDrawRegMarks myInDesign, myX1, myY1, myX2, myY2, myRegMarkOffset, myRegMarkInnerRadius, myRegMarkOuterRadius, myRegMarkRadius, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myPaperSwatch, myLayer
            End If
    End If
    myDocument.ViewPreferences.RulerOrigin = myOldRulerOrigin
End Function
Function myDrawCropMarks(myInDesign, myX1, myY1, myX2, myY2, myCropMarkLength, myCropMarkOffset, myCropMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer)
    Rem Upper left crop mark pair.
    myDrawLine myInDesign, Array(myY1, myX1 - myCropMarkOffset, myY1, myX1 - (myCropMarkOffset + myCropMarkLength)), myCropMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myDrawLine myInDesign, Array(myY1 - myCropMarkOffset, myX1, myY1 - (myCropMarkOffset + myCropMarkLength), myX1), myCropMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    Rem Lower left crop mark pair.
    myDrawLine myInDesign, Array(myY2, myX1 - myCropMarkOffset, myY2, myX1 - (myCropMarkOffset + myCropMarkLength)), myCropMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myDrawLine myInDesign, Array(myY2 + myCropMarkOffset, myX1, myY2 + myCropMarkOffset + myCropMarkLength, myX1), myCropMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    Rem Upper right crop mark pair.
    myDrawLine myInDesign, Array(myY1, myX2 + myCropMarkOffset, myY1, myX2 + myCropMarkOffset + myCropMarkLength), myCropMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myDrawLine myInDesign, Array(myY1 - myCropMarkOffset, myX2, myY1 - (myCropMarkOffset + myCropMarkLength), myX2), myCropMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    Rem Lower left crop mark pair.
    myDrawLine myInDesign, Array(myY2, myX2 + myCropMarkOffset, myY2, myX2 + myCropMarkOffset + myCropMarkLength), myCropMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myDrawLine myInDesign, Array(myY2 + myCropMarkOffset, myX2, myY2 + myCropMarkOffset + myCropMarkLength, myX2), myCropMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
End Function

Function myDrawRegMarks(myInDesign, myX1, myY1, myX2, myY2, myRegMarkOffset, myRegMarkInnerRadius, myRegMarkOuterRadius, myRegMarkRadius, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myPaperSwatch, myLayer)
    myXCenter = myX1 + ((myX2 - myX1) / 2)
    myYCenter = myY1 + ((myY2 - myY1) / 2)
    myTargetCenter = myRegMarkOffset + (myRegMarkOuterRadius)
    Rem Top registration target.
    myBounds = Array((myY1 - myTargetCenter) - myRegMarkOuterRadius, myXCenter - myRegMarkOuterRadius, (myY1 - myTargetCenter) + myRegMarkOuterRadius, myXCenter + myRegMarkOuterRadius)
    myDrawTarget myInDesign, myBounds, myRegMarkStrokeWeight, myNoneSwatch, myRegistrationSwatch, myLayer
    myBounds = Array(myY1 - (myTargetCenter + myRegMarkRadius), myXCenter, (myY1 - myTargetCenter) + myRegMarkRadius, myXCenter)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myBounds = Array(myY1 - myTargetCenter, myXCenter - myRegMarkRadius, myY1 - myTargetCenter, myXCenter + myRegMarkRadius)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myBounds = Array((myY1 - myTargetCenter) - myRegMarkInnerRadius, myXCenter - myRegMarkInnerRadius, (myY1 - myTargetCenter) + myRegMarkInnerRadius, myXCenter + myRegMarkInnerRadius)
    myDrawTarget myInDesign, myBounds, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myBounds = Array((myY1 - myTargetCenter) - myRegMarkInnerRadius, myXCenter, (myY1 - myTargetCenter) + myRegMarkInnerRadius, myXCenter)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myPaperSwatch, myNoneSwatch, myLayer
    myBounds = Array(myY1 - myTargetCenter, myXCenter - myRegMarkInnerRadius, myY1 - myTargetCenter, myXCenter + myRegMarkInnerRadius)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myPaperSwatch, myNoneSwatch, myLayer
    Rem Left registration target.
    myBounds = Array(myYCenter - myRegMarkOuterRadius, (myX1 - myTargetCenter) - myRegMarkOuterRadius, myYCenter + myRegMarkOuterRadius, (myX1 - myTargetCenter) + myRegMarkOuterRadius)
    myDrawTarget myInDesign, myBounds, myRegMarkStrokeWeight, myNoneSwatch, myRegistrationSwatch, myLayer
    myBounds = Array(myYCenter, (myX1 - myTargetCenter) - myRegMarkRadius, myYCenter, (myX1 - myTargetCenter) + myRegMarkRadius)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myBounds = Array(myYCenter - myRegMarkRadius, myX1 - myTargetCenter, myYCenter + myRegMarkRadius, myX1 - myTargetCenter)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myBounds = Array(myYCenter - myRegMarkInnerRadius, myX1 - (myTargetCenter + myRegMarkInnerRadius), myYCenter + myRegMarkInnerRadius, (myX1 - myTargetCenter) + myRegMarkInnerRadius)
    myDrawTarget myInDesign, myBounds, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myBounds = Array(myYCenter, (myX1 - myTargetCenter) - myRegMarkInnerRadius, myYCenter, (myX1 - myTargetCenter) + myRegMarkInnerRadius)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myPaperSwatch, myNoneSwatch, myLayer
    myBounds = Array(myYCenter - myRegMarkInnerRadius, myX1 - myTargetCenter, myYCenter + myRegMarkInnerRadius, myX1 - myTargetCenter)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myPaperSwatch, myNoneSwatch, myLayer
    Rem Bottom registration target.
    myBounds = Array((myY2 + myTargetCenter) - myRegMarkOuterRadius, myXCenter - myRegMarkOuterRadius, (myY2 + myTargetCenter) + myRegMarkOuterRadius, myXCenter + myRegMarkOuterRadius)
    myDrawTarget myInDesign, myBounds, myRegMarkStrokeWeight, myNoneSwatch, myRegistrationSwatch, myLayer
    myBounds = Array((myY2 + myTargetCenter) - myRegMarkRadius, myXCenter, (myY2 + myTargetCenter) + myRegMarkRadius, myXCenter)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myBounds = Array(myY2 + myTargetCenter, myXCenter - myRegMarkRadius, myY2 + myTargetCenter, myXCenter + myRegMarkRadius)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myBounds = Array((myY2 + myTargetCenter) - myRegMarkInnerRadius, myXCenter - myRegMarkInnerRadius, (myY2 + myTargetCenter) + myRegMarkInnerRadius, myXCenter + myRegMarkInnerRadius)
    myDrawTarget myInDesign, myBounds, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myBounds = Array((myY2 + myTargetCenter) - myRegMarkInnerRadius, myXCenter, (myY2 + myTargetCenter) + myRegMarkInnerRadius, myXCenter)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myPaperSwatch, myNoneSwatch, myLayer
    myBounds = Array(myY2 + myTargetCenter, myXCenter - myRegMarkInnerRadius, myY2 + myTargetCenter, myXCenter + myRegMarkInnerRadius)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myPaperSwatch, myNoneSwatch, myLayer
    Rem Right registration target.
    myBounds = Array(myYCenter - myRegMarkOuterRadius, (myX2 + myTargetCenter) - myRegMarkOuterRadius, myYCenter + myRegMarkOuterRadius, (myX2 + myTargetCenter) + myRegMarkOuterRadius)
    myDrawTarget myInDesign, myBounds, myRegMarkStrokeWeight, myNoneSwatch, myRegistrationSwatch, myLayer
    myBounds = Array(myYCenter, (myX2 + myTargetCenter) - myRegMarkRadius, myYCenter, (myX2 + myTargetCenter) + myRegMarkRadius)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myBounds = Array(myYCenter - myRegMarkRadius, myX2 + myTargetCenter, myYCenter + myRegMarkRadius, myX2 + myTargetCenter)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myBounds = Array(myYCenter - myRegMarkInnerRadius, (myX2 + myTargetCenter) - myRegMarkInnerRadius, myYCenter + myRegMarkInnerRadius, (myX2 + myTargetCenter) + myRegMarkInnerRadius)
    myDrawTarget myInDesign, myBounds, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myBounds = Array(myYCenter, (myX2 + myTargetCenter) - myRegMarkInnerRadius, myYCenter, (myX2 + myTargetCenter) + myRegMarkInnerRadius)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myPaperSwatch, myNoneSwatch, myLayer
    myBounds = Array(myYCenter - myRegMarkInnerRadius, myX2 + myTargetCenter, myYCenter + myRegMarkInnerRadius, myX2 + myTargetCenter)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myPaperSwatch, myNoneSwatch, myLayer
End Function
Function myDrawLine(myInDesign, myBounds, myStrokeWeight, myStrokeColor, myFillColor, myLayer)
    Set myGraphicLine = myInDesign.ActiveWindow.ActiveSpread.GraphicLines.Add
    myGraphicLine.Move , Array(1, 1)
    myGraphicLine.GeometricBounds = myBounds
    myGraphicLine.ItemLayer = myLayer
    myGraphicLine.StrokeWeight = myStrokeWeight
    myGraphicLine.FillColor = myFillColor
    myGraphicLine.StrokeColor = myStrokeColor
End Function
Function myDrawTarget(myInDesign, myBounds, myStrokeWeight, myFillColor, myStrokeColor, myLayer)
    Set myOval = myInDesign.ActiveWindow.ActiveSpread.Ovals.Add
    myOval.Move , Array(1, 1)
    myOval.ItemLayer = myLayer
    myOval.StrokeWeight = myStrokeWeight
    myOval.FillColor = myFillColor
    myOval.StrokeColor = myStrokeColor
    myOval.GeometricBounds = myBounds
End Function

'' SIG '' Begin signature block
'' SIG '' MIIhPgYJKoZIhvcNAQcCoIIhLzCCISsCAQExDzANBglg
'' SIG '' hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
'' SIG '' BgEEAYI3AgEeMCQCAQEEEE7wKRaZJ7VNj+Ws4Q8X66sC
'' SIG '' AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
'' SIG '' AUAapk+f+EqYiZ0XGqIfdI8sjh1f6kyOI/XfN8kdvbKg
'' SIG '' ggyUMIIF0DCCBLigAwIBAgIQCHK5i9aO5k82w+FiDw5C
'' SIG '' dzANBgkqhkiG9w0BAQsFADBsMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSswKQYDVQQDEyJEaWdpQ2Vy
'' SIG '' dCBFViBDb2RlIFNpZ25pbmcgQ0EgKFNIQTIpMB4XDTIw
'' SIG '' MTIxOTAwMDAwMFoXDTIyMTIyMTIzNTk1OVowgeYxEzAR
'' SIG '' BgsrBgEEAYI3PAIBAxMCVVMxGTAXBgsrBgEEAYI3PAIB
'' SIG '' AhMIRGVsYXdhcmUxHTAbBgNVBA8MFFByaXZhdGUgT3Jn
'' SIG '' YW5pemF0aW9uMRAwDgYDVQQFEwcyNzQ4MTI5MQswCQYD
'' SIG '' VQQGEwJVUzELMAkGA1UECBMCY2ExETAPBgNVBAcTCFNh
'' SIG '' biBKb3NlMRMwEQYDVQQKEwpBZG9iZSBJbmMuMSwwKgYD
'' SIG '' VQQLEyNJbGx1c3RyYXRvciwgSW5EZXNpZ24sIEluQ29w
'' SIG '' eSwgTXVzZTETMBEGA1UEAxMKQWRvYmUgSW5jLjCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKraHbKp
'' SIG '' 7LWhQb1eUijAwzznOPnL0ar6Bh5IyTX0X3Nmx0y/zOPp
'' SIG '' A769ixYCLdufIms+U9xBOpXey6jajunMtomUtqLHkYMN
'' SIG '' DT2jzWOCqLvnwrHjehFxLYwYIt9ymU0VqJHPcIO+0lfA
'' SIG '' s4ZoskzD5OepJsCVjURfwILDS/l51c42dKXqbPmr25vz
'' SIG '' UQBlKIg7JV7JJGj29DQMOeCI9LSY4dAUYsfaEfDx0dcb
'' SIG '' T/oDlUZAH/mGrvFonoqGwLDNNSpWkFauC3ryUlgMJ6if
'' SIG '' JX9iZIrdm6Glo/EvxbsHMzsL2TclgBXoa0mYq4PYgMH1
'' SIG '' 5XYNA9y4x7QNLRmWPpXU+4gnfN0CAwEAAaOCAfEwggHt
'' SIG '' MB8GA1UdIwQYMBaAFI/ofvBtMmoABSPHcJdqOpD/a+rU
'' SIG '' MB0GA1UdDgQWBBS5nvze3WzR/65rffm/COInbJUTtzAu
'' SIG '' BgNVHREEJzAloCMGCCsGAQUFBwgDoBcwFQwTVVMtREVM
'' SIG '' QVdBUkUtMjc0ODEyOTAOBgNVHQ8BAf8EBAMCB4AwEwYD
'' SIG '' VR0lBAwwCgYIKwYBBQUHAwMwewYDVR0fBHQwcjA3oDWg
'' SIG '' M4YxaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0VWQ29k
'' SIG '' ZVNpZ25pbmdTSEEyLWcxLmNybDA3oDWgM4YxaHR0cDov
'' SIG '' L2NybDQuZGlnaWNlcnQuY29tL0VWQ29kZVNpZ25pbmdT
'' SIG '' SEEyLWcxLmNybDBLBgNVHSAERDBCMDcGCWCGSAGG/WwD
'' SIG '' AjAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
'' SIG '' Y2VydC5jb20vQ1BTMAcGBWeBDAEDMH4GCCsGAQUFBwEB
'' SIG '' BHIwcDAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGln
'' SIG '' aWNlcnQuY29tMEgGCCsGAQUFBzAChjxodHRwOi8vY2Fj
'' SIG '' ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRFVkNvZGVT
'' SIG '' aWduaW5nQ0EtU0hBMi5jcnQwDAYDVR0TAQH/BAIwADAN
'' SIG '' BgkqhkiG9w0BAQsFAAOCAQEALl6DDJXB+ruS0J/n4zd6
'' SIG '' IxqKGcJnnn72tgm50zJjxjqD9f4gMlY5lFA4Dcz9D6ur
'' SIG '' Yc734LqeT9p+oUv2PI4KdFMpSmhdrKLkI8eTK46NHVW8
'' SIG '' U/GZctdsVZR1JvtI1ByrH/DkQS7HTKWwtbyOkKU7lfYK
'' SIG '' HIS+qUso64cM6M2asUym8CdN/3FbwJ9dGJDX9yfMISbX
'' SIG '' oIDfInSnVDD+Z9EnnpsEw9obZwNHaGdd1NJRuPrlwatk
'' SIG '' YdBJuo5kN5/eBMYb95FbK8zZf8e+5FTnEJ0PmxRakjlF
'' SIG '' xh5Zg3CCjiIjr3w/uUkOaa2PjpkNy/vuUYxCuJb53Ca6
'' SIG '' i+n/WMWWjYJLNDCCBrwwggWkoAMCAQICEAPxtOFfOoLx
'' SIG '' FJZ4s9fYR1wwDQYJKoZIhvcNAQELBQAwbDELMAkGA1UE
'' SIG '' BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcG
'' SIG '' A1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTErMCkGA1UEAxMi
'' SIG '' RGlnaUNlcnQgSGlnaCBBc3N1cmFuY2UgRVYgUm9vdCBD
'' SIG '' QTAeFw0xMjA0MTgxMjAwMDBaFw0yNzA0MTgxMjAwMDBa
'' SIG '' MGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
'' SIG '' dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20x
'' SIG '' KzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2lnbmlu
'' SIG '' ZyBDQSAoU0hBMikwggEiMA0GCSqGSIb3DQEBAQUAA4IB
'' SIG '' DwAwggEKAoIBAQCnU/oPsrUT8WTPhID8roA10bbXx6Ms
'' SIG '' rBosrPGErDo1EjqSkbpX5MTJ8y+oSDy31m7clyK6UXlh
'' SIG '' r0MvDbebtEkxrkRYPqShlqeHTyN+w2xlJJBVPqHKI3zF
'' SIG '' QunEemJFm33eY3TLnmMl+ISamq1FT659H8gTy3WbyeHh
'' SIG '' ivgLDJj0yj7QRap6HqVYkzY0visuKzFYZrQyEJ+d8FKh
'' SIG '' 7+g+03byQFrc+mo9G0utdrCMXO42uoPqMKhM3vELKlhB
'' SIG '' iK4AiasD0RaCICJ2615UOBJi4dJwJNvtH3DSZAmALeK2
'' SIG '' nc4f8rsh82zb2LMZe4pQn+/sNgpcmrdK0wigOXn93b89
'' SIG '' OgklAgMBAAGjggNYMIIDVDASBgNVHRMBAf8ECDAGAQH/
'' SIG '' AgEAMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggr
'' SIG '' BgEFBQcDAzB/BggrBgEFBQcBAQRzMHEwJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBJBggr
'' SIG '' BgEFBQcwAoY9aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0SGlnaEFzc3VyYW5jZUVWUm9vdENB
'' SIG '' LmNydDCBjwYDVR0fBIGHMIGEMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMIIBxAYDVR0gBIIBuzCC
'' SIG '' AbcwggGzBglghkgBhv1sAwIwggGkMDoGCCsGAQUFBwIB
'' SIG '' Fi5odHRwOi8vd3d3LmRpZ2ljZXJ0LmNvbS9zc2wtY3Bz
'' SIG '' LXJlcG9zaXRvcnkuaHRtMIIBZAYIKwYBBQUHAgIwggFW
'' SIG '' HoIBUgBBAG4AeQAgAHUAcwBlACAAbwBmACAAdABoAGkA
'' SIG '' cwAgAEMAZQByAHQAaQBmAGkAYwBhAHQAZQAgAGMAbwBu
'' SIG '' AHMAdABpAHQAdQB0AGUAcwAgAGEAYwBjAGUAcAB0AGEA
'' SIG '' bgBjAGUAIABvAGYAIAB0AGgAZQAgAEQAaQBnAGkAQwBl
'' SIG '' AHIAdAAgAEMAUAAvAEMAUABTACAAYQBuAGQAIAB0AGgA
'' SIG '' ZQAgAFIAZQBsAHkAaQBuAGcAIABQAGEAcgB0AHkAIABB
'' SIG '' AGcAcgBlAGUAbQBlAG4AdAAgAHcAaABpAGMAaAAgAGwA
'' SIG '' aQBtAGkAdAAgAGwAaQBhAGIAaQBsAGkAdAB5ACAAYQBu
'' SIG '' AGQAIABhAHIAZQAgAGkAbgBjAG8AcgBwAG8AcgBhAHQA
'' SIG '' ZQBkACAAaABlAHIAZQBpAG4AIABiAHkAIAByAGUAZgBl
'' SIG '' AHIAZQBuAGMAZQAuMB0GA1UdDgQWBBSP6H7wbTJqAAUj
'' SIG '' x3CXajqQ/2vq1DAfBgNVHSMEGDAWgBSxPsNpA/i/RwHU
'' SIG '' mCYaCALvY2QrwzANBgkqhkiG9w0BAQsFAAOCAQEAGTNK
'' SIG '' DIEzN9utNsnkyTq7tRsueqLi9ENCF56/TqFN4bHb6YHd
'' SIG '' nwHy5IjV6f4J/SHB7F2A0vDWwUPC/ncr2/nXkTPObNWy
'' SIG '' GTvmLtbJk0+IQI7N4fV+8Q/GWVZy6OtqQb0c1UbVfEnK
'' SIG '' ZjgVwb/gkXB3h9zJjTHJDCmiM+2N4ofNiY0/G//V4BqX
'' SIG '' i3zabfuoxrI6Zmt7AbPN2KY07BIBq5VYpcRTV6hg5ucC
'' SIG '' EqC5I2SiTbt8gSVkIb7P7kIYQ5e7pTcGr03/JqVNYUvs
'' SIG '' RkG4Zc64eZ4IlguBjIo7j8eZjKMqbphtXmHGlreKuWEt
'' SIG '' k7jrDgRD1/X+pvBi1JlqpcHB8GSUgDGCFAIwghP+AgEB
'' SIG '' MIGAMGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
'' SIG '' Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
'' SIG '' b20xKzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2ln
'' SIG '' bmluZyBDQSAoU0hBMikCEAhyuYvWjuZPNsPhYg8OQncw
'' SIG '' DQYJYIZIAWUDBAIBBQCggZwwGQYJKoZIhvcNAQkDMQwG
'' SIG '' CisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisG
'' SIG '' AQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEIEAWdhpKHW0E
'' SIG '' 8/yBcPdMcp4kAJN63z/Bc1WmPCqxqCZMMDAGCisGAQQB
'' SIG '' gjcCAQwxIjAgoB6AHABBAGQAbwBiAGUAIABJAG4ARABl
'' SIG '' AHMAaQBnAG4wDQYJKoZIhvcNAQEBBQAEggEASVMKr3Fq
'' SIG '' pQUVeYgS+nq0sMgQg49UHlCiGAz8ouRFquOhqlt7LQI+
'' SIG '' 2b4HdlyLXw3hn+j1i2itgf00cG0Htz+jhIetru0ZWAHC
'' SIG '' 5rDWEXQPW1G/+beOFjztWD4aVuO6zoFMrdL30rFBZ671
'' SIG '' 1zAB3tK7H9hRiETEw+0tIQ88m3rJiMZQqnuqqhTDD08l
'' SIG '' Y+yXExNfZkcRPdJogO5J/1bXiu09qmUZsNv6EF1jBOoQ
'' SIG '' GDT/e5544VTyc7m21YgUJ9USarW3boyVtCnWdGFm4RIC
'' SIG '' GkLlfOzlzbNvp/tI1Hao23yN5TOEgXT6Pjnq0tY+ibjE
'' SIG '' zZhe2DVZg60mVdoBoiIWLXkMeqGCEbMwghGvBgorBgEE
'' SIG '' AYI3AwMBMYIRnzCCEZsGCSqGSIb3DQEHAqCCEYwwghGI
'' SIG '' AgEDMQ8wDQYJYIZIAWUDBAIBBQAweAYLKoZIhvcNAQkQ
'' SIG '' AQSgaQRnMGUCAQEGCWCGSAGG/WwHATAxMA0GCWCGSAFl
'' SIG '' AwQCAQUABCABMCdM6as2onJaDzXSilqJIRgAvA5O2iPB
'' SIG '' u59NdzbA6gIRAMFhLuIRzxguA7xodM9Trx8YDzIwMjIw
'' SIG '' NDE4MTkwMzI4WqCCDXwwggbGMIIErqADAgECAhAKekqI
'' SIG '' nsmZQpAGYzhNhpedMA0GCSqGSIb3DQEBCwUAMGMxCzAJ
'' SIG '' BgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5j
'' SIG '' LjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBS
'' SIG '' U0E0MDk2IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcN
'' SIG '' MjIwMzI5MDAwMDAwWhcNMzMwMzE0MjM1OTU5WjBMMQsw
'' SIG '' CQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIElu
'' SIG '' Yy4xJDAiBgNVBAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAy
'' SIG '' MDIyIC0gMjCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCC
'' SIG '' AgoCggIBALkqliOmXLxf1knwFYIY9DPuzFxs4+AlLtIx
'' SIG '' 5DxArvurxON4XX5cNur1JY1Do4HrOGP5PIhp3jzSMFEN
'' SIG '' MQe6Rm7po0tI6IlBfw2y1vmE8Zg+C78KhBJxbKFiJgHT
'' SIG '' zsNs/aw7ftwqHKm9MMYW2Nq867Lxg9GfzQnFuUFqRUIj
'' SIG '' QVr4YNNlLD5+Xr2Wp/D8sfT0KM9CeR87x5MHaGjlRDRS
'' SIG '' Xw9Q3tRZLER0wDJHGVvimC6P0Mo//8ZnzzyTlU6E6XYY
'' SIG '' mJkRFMUrDKAz200kheiClOEvA+5/hQLJhuHVGBS3BEXz
'' SIG '' 4Di9or16cZjsFef9LuzSmwCKrB2NO4Bo/tBZmCbO4O2u
'' SIG '' fyguwp7gC0vICNEyu4P6IzzZ/9KMu/dDI9/nw1oFYn5w
'' SIG '' LOUrsj1j6siugSBrQ4nIfl+wGt0ZvZ90QQqvuY4J03Sh
'' SIG '' L7BUdsGQT5TshmH/2xEvkgMwzjC3iw9dRLNDHSNQzZHX
'' SIG '' L537/M2xwafEDsTvQD4ZOgLUMalpoEn5deGb6GjkagyP
'' SIG '' 6+SxIXuGZ1h+fx/oK+QUshbWgaHK2jCQa+5vdcCwNiay
'' SIG '' CDv/vb5/bBMY38ZtpHlJrYt/YYcFaPfUcONCleieu5tL
'' SIG '' suK2QT3nr6caKMmtYbCgQRgZTu1Hm2GV7T4LYVrqPnqY
'' SIG '' klHNP8lE54CLKUJy93my3YTqJ+7+fXprAgMBAAGjggGL
'' SIG '' MIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIw
'' SIG '' ADAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAE
'' SIG '' GTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEwHwYDVR0j
'' SIG '' BBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYDVR0O
'' SIG '' BBYEFI1kt4kh/lZYRIRhp+pvHDaP3a8NMFoGA1UdHwRT
'' SIG '' MFEwT6BNoEuGSWh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNv
'' SIG '' bS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZU
'' SIG '' aW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGD
'' SIG '' MIGAMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdp
'' SIG '' Y2VydC5jb20wWAYIKwYBBQUHMAKGTGh0dHA6Ly9jYWNl
'' SIG '' cnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRH
'' SIG '' NFJTQTQwOTZTSEEyNTZUaW1lU3RhbXBpbmdDQS5jcnQw
'' SIG '' DQYJKoZIhvcNAQELBQADggIBAA0tI3Sm0fX46kuZPwHk
'' SIG '' 9gzkrxad2bOMl4IpnENvAS2rOLVwEb+EGYs/XeWGT76T
'' SIG '' Ot4qOVo5TtiEWaW8G5iq6Gzv0UhpGThbz4k5HXBw2U7f
'' SIG '' IyJs1d/2WcuhwupMdsqh3KErlribVakaa33R9QIJT4LW
'' SIG '' pXOIxJiA3+5JlbezzMWn7g7h7x44ip/vEckxSli23zh8
'' SIG '' y/pc9+RTv24KfH7X3pjVKWWJD6KcwGX0ASJlx+pedKZb
'' SIG '' NZJQfPQXpodkTz5GiRZjIGvL8nvQNeNKcEiptucdYL0E
'' SIG '' IhUlcAZyqUQ7aUcR0+7px6A+TxC5MDbk86ppCaiLfmSi
'' SIG '' ZZQR+24y8fW7OK3NwJMR1TJ4Sks3KkzzXNy2hcC7cDBV
'' SIG '' eNaY/lRtf3GpSBp43UZ3Lht6wDOK+EoojBKoc88t+dMj
'' SIG '' 8p4Z4A2UKKDr2xpRoJWCjihrpM6ddt6pc6pIallDrl/q
'' SIG '' +A8GQp3fBmiW/iqgdFtjZt5rLLh4qk1wbfAs8QcVfjW0
'' SIG '' 5rUMopml1xVrNQ6F1uAszOAMJLh8UgsemXzvyMjFjFhp
'' SIG '' r6s94c/MfRWuFL+Kcd/Kl7HYR+ocheBFThIcFClYzG/T
'' SIG '' f8u+wQ5KbyCcrtlzMlkI5y2SoRoR/jKYpl0rl+CL05zM
'' SIG '' bbUNrkdjOEcXW28T2moQbh9Jt0RbtAgKh1pZBHYRoad3
'' SIG '' AhMcMIIGrjCCBJagAwIBAgIQBzY3tyRUfNhHrP0oZipe
'' SIG '' WzANBgkqhkiG9w0BAQsFADBiMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdpQ2Vy
'' SIG '' dCBUcnVzdGVkIFJvb3QgRzQwHhcNMjIwMzIzMDAwMDAw
'' SIG '' WhcNMzcwMzIyMjM1OTU5WjBjMQswCQYDVQQGEwJVUzEX
'' SIG '' MBUGA1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNVBAMT
'' SIG '' MkRpZ2lDZXJ0IFRydXN0ZWQgRzQgUlNBNDA5NiBTSEEy
'' SIG '' NTYgVGltZVN0YW1waW5nIENBMIICIjANBgkqhkiG9w0B
'' SIG '' AQEFAAOCAg8AMIICCgKCAgEAxoY1BkmzwT1ySVFVxyUD
'' SIG '' xPKRN6mXUaHW0oPRnkyibaCwzIP5WvYRoUQVQl+kiPNo
'' SIG '' +n3znIkLf50fng8zH1ATCyZzlm34V6gCff1DtITaEfFz
'' SIG '' sbPuK4CEiiIY3+vaPcQXf6sZKz5C3GeO6lE98NZW1Oco
'' SIG '' LevTsbV15x8GZY2UKdPZ7Gnf2ZCHRgB720RBidx8ald6
'' SIG '' 8Dd5n12sy+iEZLRS8nZH92GDGd1ftFQLIWhuNyG7QKxf
'' SIG '' st5Kfc71ORJn7w6lY2zkpsUdzTYNXNXmG6jBZHRAp8By
'' SIG '' xbpOH7G1WE15/tePc5OsLDnipUjW8LAxE6lXKZYnLvWH
'' SIG '' po9OdhVVJnCYJn+gGkcgQ+NDY4B7dW4nJZCYOjgRs/b2
'' SIG '' nuY7W+yB3iIU2YIqx5K/oN7jPqJz+ucfWmyU8lKVEStY
'' SIG '' dEAoq3NDzt9KoRxrOMUp88qqlnNCaJ+2RrOdOqPVA+C/
'' SIG '' 8KI8ykLcGEh/FDTP0kyr75s9/g64ZCr6dSgkQe1CvwWc
'' SIG '' ZklSUPRR8zZJTYsg0ixXNXkrqPNFYLwjjVj33GHek/45
'' SIG '' wPmyMKVM1+mYSlg+0wOI/rOP015LdhJRk8mMDDtbiiKo
'' SIG '' wSYI+RQQEgN9XyO7ZONj4KbhPvbCdLI/Hgl27KtdRnXi
'' SIG '' YKNYCQEoAA6EVO7O6V3IXjASvUaetdN2udIOa5kM0jO0
'' SIG '' zbECAwEAAaOCAV0wggFZMBIGA1UdEwEB/wQIMAYBAf8C
'' SIG '' AQAwHQYDVR0OBBYEFLoW2W1NhS9zKXaaL3WMaiCPnshv
'' SIG '' MB8GA1UdIwQYMBaAFOzX44LScV1kTN8uZz/nupiuHA9P
'' SIG '' MA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggrBgEF
'' SIG '' BQcDCDB3BggrBgEFBQcBAQRrMGkwJAYIKwYBBQUHMAGG
'' SIG '' GGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBBBggrBgEF
'' SIG '' BQcwAoY1aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29t
'' SIG '' L0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcnQwQwYDVR0f
'' SIG '' BDwwOjA4oDagNIYyaHR0cDovL2NybDMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcmwwIAYD
'' SIG '' VR0gBBkwFzAIBgZngQwBBAIwCwYJYIZIAYb9bAcBMA0G
'' SIG '' CSqGSIb3DQEBCwUAA4ICAQB9WY7Ak7ZvmKlEIgF+ZtbY
'' SIG '' IULhsBguEE0TzzBTzr8Y+8dQXeJLKftwig2qKWn8acHP
'' SIG '' HQfpPmDI2AvlXFvXbYf6hCAlNDFnzbYSlm/EUExiHQwI
'' SIG '' gqgWvalWzxVzjQEiJc6VaT9Hd/tydBTX/6tPiix6q4XN
'' SIG '' Q1/tYLaqT5Fmniye4Iqs5f2MvGQmh2ySvZ180HAKfO+o
'' SIG '' vHVPulr3qRCyXen/KFSJ8NWKcXZl2szwcqMj+sAngkSu
'' SIG '' mScbqyQeJsG33irr9p6xeZmBo1aGqwpFyd/EjaDnmPv7
'' SIG '' pp1yr8THwcFqcdnGE4AJxLafzYeHJLtPo0m5d2aR8XKc
'' SIG '' 6UsCUqc3fpNTrDsdCEkPlM05et3/JWOZJyw9P2un8WbD
'' SIG '' Qc1PtkCbISFA0LcTJM3cHXg65J6t5TRxktcma+Q4c6um
'' SIG '' AU+9Pzt4rUyt+8SVe+0KXzM5h0F4ejjpnOHdI/0dKNPH
'' SIG '' +ejxmF/7K9h+8kaddSweJywm228Vex4Ziza4k9Tm8heZ
'' SIG '' Wcpw8De/mADfIBZPJ/tgZxahZrrdVcA6KYawmKAr7ZVB
'' SIG '' tzrVFZgxtGIJDwq9gdkT/r+k0fNX2bwE+oLeMt8EifAA
'' SIG '' zV3C+dAjfwAL5HYCJtnwZXZCpimHCUcr5n8apIUP/JiW
'' SIG '' 9lVUKx+A+sDyDivl1vupL0QVSucTDh3bNzgaoSv27dZ8
'' SIG '' /DGCA3YwggNyAgEBMHcwYzELMAkGA1UEBhMCVVMxFzAV
'' SIG '' BgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJE
'' SIG '' aWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2
'' SIG '' IFRpbWVTdGFtcGluZyBDQQIQCnpKiJ7JmUKQBmM4TYaX
'' SIG '' nTANBglghkgBZQMEAgEFAKCB0TAaBgkqhkiG9w0BCQMx
'' SIG '' DQYLKoZIhvcNAQkQAQQwHAYJKoZIhvcNAQkFMQ8XDTIy
'' SIG '' MDQxODE5MDMyOFowKwYLKoZIhvcNAQkQAgwxHDAaMBgw
'' SIG '' FgQUhQjzhlFcs9MHfba0t8B/G0peQd4wLwYJKoZIhvcN
'' SIG '' AQkEMSIEIBHHVsd0ckXjzAa8ZW2a37/8KPmwL6hvOLKs
'' SIG '' j02CXoprMDcGCyqGSIb3DQEJEAIvMSgwJjAkMCIEIJ2m
'' SIG '' kBXDScbBiXhFujWCrXDIj6QpO9tqvpwr0lOSeeY7MA0G
'' SIG '' CSqGSIb3DQEBAQUABIICAGXDc6o0Atl3Nw0xjqoTuWg1
'' SIG '' Jh5DrwVTP7ZjRwIExVKR7rvXOVWQhn3c7XojPgLmrPyO
'' SIG '' 4vTEqwiYC9w6qjDAgJQUSDruCfSLnKkRNBTUy2K6bSf7
'' SIG '' yI+qs1iN0sN5AiTVcMFiyx+u4G8634Fcg2qbq4FKttrF
'' SIG '' tHN638qQLcClWFR34XiaIkYDvBqxc4qA3hUOddKtrqab
'' SIG '' MUaWPY63sfVQF24RwLZS7ym5peAoG0ORP56ncik7Z4qS
'' SIG '' kzW3uyL6+kwnWH9DzrG2MMJzg3JQv7fOE+SqcRUrDN5a
'' SIG '' sHCkNfoUeS8FwIBPEevK0KqdebXRh2Yi8ONs+ivj+hYG
'' SIG '' a3iTi3uLJkDxVT8nfCMyRoQtsHbdKc2WySXKM2ECoFxr
'' SIG '' 1331evVkhtgd5MyGgeugYQZrX1iBaEI3p+/Am6tAzRq3
'' SIG '' 0/EGSlhwVM7IqkKsapAGWfEhAXH3Pxeydz/bSf56j5eN
'' SIG '' Y/kPf4Scjghlcj/IBhqIeVfS1hJR3D8ymMxBePTR7nvN
'' SIG '' pWVfmQa+yKrpH+yp71mulxW/lx/RuOvYPwWluji6gh0F
'' SIG '' dV9Sz7WWREfWmOPrV6WR9HV30yKcUaljFI8gTezLfftX
'' SIG '' Jfg07B7alswdditwFF7QGJA9vIqAoaI0l1ydpygtaopg
'' SIG '' odXIYddea/p8V0YfDTv6dewLV+Kgfv3iDqmuJDlwQK94
'' SIG '' End signature block
